package com.burhanstore.neonbubblequest.Utils.network


import android.app.Dialog
import android.content.Context
import android.content.SharedPreferences

class PrefManager(context: Context) {

    private val pref: SharedPreferences =
        context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
    private val editor: SharedPreferences.Editor = pref.edit()

    fun setString(key: String, value: String) {
        editor.putString(key, value)
        editor.commit() // You can use .apply() if you prefer async write
    }

    fun getString(key: String): String {
        return pref.getString(key, "") ?: ""
    }

    companion object {
        const val PREF_NAME = "burhanstore"

        var iErrorDialog: Dialog? = null
        var notEnDialog: Dialog? = null
    }
}
